<?php
namespace VM\AdminBundle\Command;

use Doctrine\Bundle\DoctrineBundle\Registry;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\EntityManager;
use Import\ApiBundle\Entity\AllegroCategoryItem;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Validator\Constraints\DateTime;
use VM\AdminBundle\Services\ApiGetter;
use VM\ApiBundle\Entity\BankServiceOptions;
use VM\ApiBundle\Entity\Company;
use VM\ApiBundle\Entity\CompanyAllegroCategoryItem;
use VM\ApiBundle\Entity\CompanyBankServiceOption;
use VM\ApiBundle\Entity\Round;
use VM\ApiBundle\Entity\SummaryCompanyRound;

class FinalResultsCommand extends ContainerAwareCommand
{
    private $Container;

    protected function configure()
    {
        $this
            ->setName('game:final:results')
            ->setDescription('Display sorted results of the game.')
            ->addOption('start-date', null, InputOption::VALUE_OPTIONAL, 'First round must start after this date (2008-01-01 00:00:01)', "2008-01-01 00:00:01")
            ->addOption('end-date', null, InputOption::VALUE_OPTIONAL, 'Last round must start before this date (2018-01-01 00:00:01)', "2018-01-01 00:00:01")
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $startDate = new \DateTime($input->getOption('start-date'));
        $endDate = new \DateTime($input->getOption('end-date'));

        /** @var $ApiGetter ApiGetter */
        $ApiGetter = $this->getContainer()->get('vm_admin.api.getter');

        $webDir = __DIR__ . '/../../../../web/';

        $EntityManager = $this->getDoctrine();

        $unsortedCompanies = $EntityManager->getRepository('VMApiBundle:Company')->findAll();
        $unsortedCompanies = new ArrayCollection($unsortedCompanies);
        $iterator = $unsortedCompanies->getIterator();
        $iterator->uasort(function (Company $a, Company $b) {
            return ($a->getId() < $b->getId()) ? -1 : 1;
        });

        $Companies = new ArrayCollection(iterator_to_array($iterator));

        $results = array();
        $results[] = array(
//            'CompanyId',
            'Nazwa firmy',
//            'GroupId',
            'Nazwa grupy',
            'Imię nauczyciela',
            'Nazwisko Nauczyciela',
            'Email nauczyciela',
            'Suma zysku netto',
            'Suma przychodu'
        );
        /** @var $Company Company */
        foreach($Companies as $Company)
        {
            $Rounds = $Company->getUserGroups()->getRounds();
            $roundsPlayedBetweenDates = true;

            /** @var $Round Round */
            foreach($Rounds as $Round)
            {
                $startAt = $Round->getStartAt();
                if(!empty($startAt))
                {
                    $roundsPlayedBetweenDates =
                        $roundsPlayedBetweenDates &&
                        (
                            $startAt >= $startDate
                            &&
                            $startAt <= $endDate
                        )
                    ;
                }
            }

            if($roundsPlayedBetweenDates)
            {
                $Teacher = $Company->getUserGroups()->getUser();
                $teacherEmail = $Teacher->getEmail();

                if(strpos($teacherEmail, '@vm.pl') === false && strpos($teacherEmail, 'testowicz') === false)
                {
                    $CompanySummaries = $Company->getSummaryCompanyRound();
                    /** @var $SummaryCompanyRound SummaryCompanyRound */
                    foreach($CompanySummaries as $SummaryCompanyRound)
                    {
                        $profits = json_decode($SummaryCompanyRound->getResults(), true)['RachunekZyskowIStrat']['zyskNetto'];
                        $profitSum = 0;
                        foreach($profits as $profit)
                        {
                            $profitSum += $profit;
                        }

                        $incomes = json_decode($SummaryCompanyRound->getResults(), true)['RachunekZyskowIStrat']['przychodyNettoZeSprzedazy']['produktow'];
                        $incomeSum = 0;
                        foreach($incomes as $income)
                        {
                            $incomeSum += $income;
                        }
                        $results[$Company->getId()] = array(
    //                        $Company->getId(),
                            $Company->getName(),
    //                        $Company->getUserGroups()->getId(),
                            $Company->getUserGroups()->getName(),
                            $Teacher->getName(),
                            $Teacher->getSurname(),
                            $teacherEmail,
                            $profitSum,
                            $incomeSum
                        );
                    }
                }
            }
        }

        $fileName = 'game_results_('.$startDate->format('Y-m-d H:i:s').' - '.$endDate->format('Y-m-d H:i:s').').csv';
        $file = fopen($webDir.$fileName,'w');
        foreach ($results as $result) {
            fputcsv($file, $result, ';', '"');
        }
        $output->writeln('Wyniki zapisano do pliku: '.$webDir.$fileName);
    }


    /**
     * @return EntityManager
     */
    protected function getDoctrine()
    {
        return $this->getContainer()->get('doctrine.orm.default_entity_manager');
    }
}